import random
import time
from RPiKeyboardConfig import RPiKeyboardConfig

keyboard = RPiKeyboardConfig()

def benchmark_updates(iterations=10):
    # Switch to direct LED mode
    keyboard.set_led_direct_effect()

    all_leds = keyboard.get_leds()
    times = []

    for i in range(iterations):
        start = time.time()

        # Fill with random colours
        for led in all_leds:
            h = random.randint(0, 255)
            s = 255
            v = 255
            keyboard.set_led_by_idx(idx=led.idx, colour=(h, s, v))

        # Push to keyboard
        keyboard.send_leds()

        end = time.time()
        times.append(end - start)
        print(f"Iteration {i+1}: {end - start:.3f} sec")

    avg = sum(times) / len(times)
    print(f"\nAverage per update: {avg:.3f} sec over {iterations} iterations")



if __name__ == "__main__":
    benchmark_updates(iterations=1000)
